<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function razer_add_settings_page() {
    add_submenu_page(
        'woocommerce',
        'Razer Gold Bot',
        'Razer Gold Bot',
        'manage_options',
        'razer-gold-bot',
        'razer_settings_page_content'
    );
}
add_action( 'admin_menu', 'razer_add_settings_page' );

function razer_register_settings() {
    register_setting( 'razer_gold_settings', 'razer_api_url' );
    register_setting( 'razer_gold_settings', 'razer_api_key' );
    register_setting( 'razer_gold_settings', 'razer_debug_enabled' );
    register_setting( 'razer_gold_settings', 'razer_webhook_secret' );
}
add_action( 'admin_init', 'razer_register_settings' );

function razer_settings_page_content() {
    if ( ! current_user_can( 'manage_options' ) ) {
        return;
    }

    $test_result    = '';
    $test_class     = '';
    $products_list  = array();

    if ( isset( $_POST['razer_save_settings'] ) ) {
        check_admin_referer( 'razer_save_settings_action', 'razer_save_settings_nonce' );

        $api_url = isset( $_POST['razer_api_url'] ) ? sanitize_text_field( wp_unslash( $_POST['razer_api_url'] ) ) : '';
        update_option( 'razer_api_url', $api_url );

        if ( ! empty( $_POST['razer_api_key'] ) ) {
            $api_key = sanitize_text_field( wp_unslash( $_POST['razer_api_key'] ) );
            update_option( 'razer_api_key', $api_key );
        }

        $debug_enabled = isset( $_POST['razer_debug_enabled'] ) ? 'yes' : 'no';
        update_option( 'razer_debug_enabled', $debug_enabled );

        $webhook_secret = isset( $_POST['razer_webhook_secret'] ) ? sanitize_text_field( wp_unslash( $_POST['razer_webhook_secret'] ) ) : '';
        if ( empty( $webhook_secret ) && empty( get_option( 'razer_webhook_secret', '' ) ) ) {
            $webhook_secret = wp_generate_password( 64, false, false );
        } elseif ( empty( $webhook_secret ) ) {
            $webhook_secret = get_option( 'razer_webhook_secret' );
        }
        update_option( 'razer_webhook_secret', $webhook_secret );

        echo '<div class="notice notice-success"><p>تم حفظ الإعدادات بنجاح</p></div>';
    }

    if ( isset( $_POST['razer_test_connection'] ) ) {
        check_admin_referer( 'razer_test_connection_action', 'razer_test_connection_nonce' );

        $result = razer_api_request( 'GET', 'api/orders' );

        if ( is_wp_error( $result ) ) {
            $test_result = 'فشل الاتصال: ' . $result->get_error_message();
            $test_class  = 'notice-error';
        } else {
            $test_result = 'تم الاتصال بنجاح ✅';
            $test_class  = 'notice-success';
        }
    }

    $api_url        = get_option( 'razer_api_url', '' );
    $api_key        = get_option( 'razer_api_key', '' );
    $debug_enabled  = get_option( 'razer_debug_enabled', 'yes' );
    $webhook_secret = get_option( 'razer_webhook_secret', '' );
    $webhook_url    = rest_url( 'razer-gold/v1/webhook' );

    $available_products = array(
        '100'  => '100 ماسة - 1$',
        '210'  => '210 ماسة - 2$',
        '530'  => '530 ماسة - 5$',
        '1080' => '1080 ماسة - 10$',
        '2200' => '2200 ماسة - 20$',
    );

    ?>
    <div class="wrap">
        <h1>إعدادات Razer Gold Bot</h1>

        <?php if ( ! empty( $test_result ) ) : ?>
            <div class="notice <?php echo esc_attr( $test_class ); ?>"><p><?php echo esc_html( $test_result ); ?></p></div>
        <?php endif; ?>

        <form method="post" action="">
            <?php wp_nonce_field( 'razer_save_settings_action', 'razer_save_settings_nonce' ); ?>

            <table class="form-table">
                <tr>
                    <th scope="row"><label for="razer_api_url">رابط API</label></th>
                    <td>
                        <input type="text" id="razer_api_url" name="razer_api_url" value="<?php echo esc_attr( $api_url ); ?>" class="regular-text" dir="ltr" placeholder="https://example.com" />
                        <p class="description">رابط خادم Razer Gold Bot</p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="razer_api_key">مفتاح API</label></th>
                    <td>
                        <input type="password" id="razer_api_key" name="razer_api_key" value="<?php echo esc_attr( $api_key ); ?>" class="regular-text" dir="ltr" />
                        <p class="description">مفتاح التوثيق X-API-Key</p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="razer_webhook_secret">مفتاح Webhook</label></th>
                    <td>
                        <input type="text" id="razer_webhook_secret" name="razer_webhook_secret" value="<?php echo esc_attr( $webhook_secret ); ?>" class="regular-text" dir="ltr" />
                        <p class="description">مفتاح التحقق من طلبات Webhook (يتم إنشاؤه تلقائياً إذا تُرك فارغاً)</p>
                    </td>
                </tr>
                <tr>
                    <th scope="row">رابط Webhook</th>
                    <td>
                        <code dir="ltr"><?php echo esc_html( $webhook_url ); ?></code>
                        <p class="description">استخدم هذا الرابط في إعدادات البوت لاستقبال التحديثات</p>
                    </td>
                </tr>
                <tr>
                    <th scope="row"><label for="razer_debug_enabled">سجل التصحيح</label></th>
                    <td>
                        <label>
                            <input type="checkbox" id="razer_debug_enabled" name="razer_debug_enabled" value="yes" <?php checked( $debug_enabled, 'yes' ); ?> />
                            تفعيل تسجيل الأحداث للتصحيح
                        </label>
                        <p class="description">السجلات تظهر في WooCommerce > الحالة > السجلات (razer-gold-topup)</p>
                    </td>
                </tr>
            </table>

            <p class="submit">
                <input type="submit" name="razer_save_settings" class="button-primary" value="حفظ الإعدادات" />
            </p>
        </form>

        <hr />

        <h2>اختبار الاتصال</h2>
        <form method="post" action="">
            <?php wp_nonce_field( 'razer_test_connection_action', 'razer_test_connection_nonce' ); ?>
            <p>
                <input type="submit" name="razer_test_connection" class="button-secondary" value="اختبار الاتصال" />
            </p>
        </form>

        <hr />

        <h2>المنتجات المتاحة</h2>
        <table class="widefat fixed striped">
            <thead>
                <tr>
                    <th>اسم المنتج</th>
                    <th>الوصف</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ( $available_products as $code => $desc ) : ?>
                    <tr>
                        <td><code><?php echo esc_html( $code ); ?></code></td>
                        <td><?php echo esc_html( $desc ); ?></td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
    <?php
}
