<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function razer_api_request( $method, $endpoint, $args = array() ) {
    $base_url = rtrim( get_option( 'razer_api_url', '' ), '/' );
    $api_key  = get_option( 'razer_api_key', '' );

    if ( empty( $base_url ) ) {
        return new WP_Error( 'razer_no_url', 'رابط API غير محدد' );
    }

    if ( empty( $api_key ) ) {
        return new WP_Error( 'razer_no_key', 'مفتاح API غير محدد' );
    }

    $url = $base_url . '/' . ltrim( $endpoint, '/' );

    $headers = array(
        'X-API-Key'    => $api_key,
        'Content-Type' => 'application/json',
        'Accept'       => 'application/json',
    );

    $wp_args = array(
        'method'  => strtoupper( $method ),
        'headers' => $headers,
        'timeout' => 30,
    );

    if ( ! empty( $args['body'] ) ) {
        $wp_args['body'] = wp_json_encode( $args['body'] );
        razer_log( 'Request: ' . strtoupper( $method ) . ' ' . $url );
        razer_log( 'Body: ' . razer_sanitize_json_for_log( $wp_args['body'] ) );
    } else {
        razer_log( 'Request: ' . strtoupper( $method ) . ' ' . $url );
    }

    $response = wp_remote_request( $url, $wp_args );

    if ( is_wp_error( $response ) ) {
        razer_log( 'HTTP Error: ' . $response->get_error_message() );
        return $response;
    }

    $code = wp_remote_retrieve_response_code( $response );
    $body = wp_remote_retrieve_body( $response );

    razer_log( 'Response code: ' . $code );
    razer_log( 'Response body: ' . razer_sanitize_json_for_log( $body ) );

    $decoded = json_decode( $body, true );

    if ( null === $decoded ) {
        return new WP_Error( 'razer_invalid_json', 'استجابة JSON غير صالحة من الخادم' );
    }

    if ( $code >= 400 ) {
        $error_msg = isset( $decoded['error'] ) ? $decoded['error'] : 'خطأ HTTP ' . $code;
        return new WP_Error( 'razer_http_error', $error_msg );
    }

    return $decoded;
}
