<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function razer_sanitize_json_for_log( $body ) {
    $data = json_decode( $body, true );
    if ( ! is_array( $data ) ) {
        return $body;
    }

    $sensitive_keys = array( 'api_key', 'password', 'token', 'secret', 'Authorization', 'X-API-Key' );

    $walker = function ( &$item, $key ) use ( $sensitive_keys ) {
        if ( in_array( $key, $sensitive_keys, true ) ) {
            $item = '***';
        }
    };

    array_walk_recursive( $data, $walker );

    return wp_json_encode( $data, JSON_UNESCAPED_UNICODE );
}

function razer_log( $message ) {
    $enabled = get_option( 'razer_debug_enabled', 'yes' );
    if ( 'yes' !== $enabled ) {
        return;
    }

    $prefix  = '[Razer Gold TopUp] ';
    $message = $prefix . $message;

    if ( function_exists( 'wc_get_logger' ) ) {
        $logger = wc_get_logger();
        $logger->info( $message, array( 'source' => 'razer-gold-topup' ) );
    }

    error_log( $message );
}
