<?php
if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

function razer_product_data_tab( $tabs ) {
    $tabs['razer_gold_topup'] = array(
        'label'    => 'Razer Gold TopUp',
        'target'   => 'razer_gold_topup_data',
        'class'    => array(),
        'priority' => 80,
    );
    return $tabs;
}
add_filter( 'woocommerce_product_data_tabs', 'razer_product_data_tab' );

function razer_product_data_panel() {
    global $post;
    $product_id = $post->ID;
    ?>
    <div id="razer_gold_topup_data" class="panel woocommerce_options_panel">
        <?php
        woocommerce_wp_checkbox( array(
            'id'          => '_razer_integration_enabled',
            'label'       => 'تفعيل التكامل',
            'description' => 'تفعيل الشحن التلقائي عبر Razer Gold Bot',
            'value'       => get_post_meta( $product_id, '_razer_integration_enabled', true ),
        ) );

        woocommerce_wp_select( array(
            'id'          => '_razer_product_mapping',
            'label'       => 'ربط المنتج',
            'description' => 'اختر باقة الماسات المقابلة',
            'value'       => get_post_meta( $product_id, '_razer_product_mapping', true ),
            'options'     => array(
                ''     => '-- اختر --',
                '100'  => '100 ماسة - 1$',
                '210'  => '210 ماسة - 2$',
                '530'  => '530 ماسة - 5$',
                '1080' => '1080 ماسة - 10$',
                '2200' => '2200 ماسة - 20$',
            ),
        ) );

        woocommerce_wp_checkbox( array(
            'id'          => '_razer_enable_player_id',
            'label'       => 'حقل معرف اللاعب',
            'description' => 'إظهار حقل معرف اللاعب في صفحة المنتج',
            'value'       => get_post_meta( $product_id, '_razer_enable_player_id', true ),
        ) );
        ?>
    </div>
    <?php
}
add_action( 'woocommerce_product_data_panels', 'razer_product_data_panel' );

function razer_save_product_fields( $post_id ) {
    $enabled   = isset( $_POST['_razer_integration_enabled'] ) ? 'yes' : 'no';
    $mapping   = isset( $_POST['_razer_product_mapping'] ) ? sanitize_text_field( wp_unslash( $_POST['_razer_product_mapping'] ) ) : '';
    $player_id = isset( $_POST['_razer_enable_player_id'] ) ? 'yes' : 'no';

    update_post_meta( $post_id, '_razer_integration_enabled', $enabled );
    update_post_meta( $post_id, '_razer_product_mapping', $mapping );
    update_post_meta( $post_id, '_razer_enable_player_id', $player_id );
}
add_action( 'woocommerce_process_product_meta', 'razer_save_product_fields' );

function razer_variation_fields( $loop, $variation_data, $variation ) {
    $variation_id = $variation->ID;

    woocommerce_wp_checkbox( array(
        'id'            => '_razer_integration_enabled_' . $variation_id,
        'name'          => '_razer_integration_enabled[' . $variation_id . ']',
        'label'         => 'تفعيل Razer Gold',
        'value'         => get_post_meta( $variation_id, '_razer_integration_enabled', true ),
        'wrapper_class' => 'form-row form-row-first',
    ) );

    woocommerce_wp_select( array(
        'id'            => '_razer_product_mapping_' . $variation_id,
        'name'          => '_razer_product_mapping[' . $variation_id . ']',
        'label'         => 'ربط المنتج',
        'value'         => get_post_meta( $variation_id, '_razer_product_mapping', true ),
        'wrapper_class' => 'form-row form-row-last',
        'options'       => array(
            ''     => '-- اختر --',
            '100'  => '100 ماسة - 1$',
            '210'  => '210 ماسة - 2$',
            '530'  => '530 ماسة - 5$',
            '1080' => '1080 ماسة - 10$',
            '2200' => '2200 ماسة - 20$',
        ),
    ) );

    woocommerce_wp_checkbox( array(
        'id'            => '_razer_enable_player_id_' . $variation_id,
        'name'          => '_razer_enable_player_id[' . $variation_id . ']',
        'label'         => 'حقل معرف اللاعب',
        'value'         => get_post_meta( $variation_id, '_razer_enable_player_id', true ),
        'wrapper_class' => 'form-row form-row-first',
    ) );
}
add_action( 'woocommerce_variation_options_pricing', 'razer_variation_fields', 10, 3 );

function razer_save_variation_fields( $variation_id, $i ) {
    $enabled = isset( $_POST['_razer_integration_enabled'][ $variation_id ] ) ? 'yes' : 'no';
    $mapping = isset( $_POST['_razer_product_mapping'][ $variation_id ] ) ? sanitize_text_field( wp_unslash( $_POST['_razer_product_mapping'][ $variation_id ] ) ) : '';
    $player  = isset( $_POST['_razer_enable_player_id'][ $variation_id ] ) ? 'yes' : 'no';

    update_post_meta( $variation_id, '_razer_integration_enabled', $enabled );
    update_post_meta( $variation_id, '_razer_product_mapping', $mapping );
    update_post_meta( $variation_id, '_razer_enable_player_id', $player );
}
add_action( 'woocommerce_save_product_variation', 'razer_save_variation_fields', 10, 2 );

function razer_display_player_id_field() {
    global $product;

    if ( ! $product ) {
        return;
    }

    $product_id = $product->get_id();
    $enabled    = get_post_meta( $product_id, '_razer_enable_player_id', true );

    if ( 'yes' !== $enabled ) {
        return;
    }

    echo '<div class="razer-player-id-field" style="margin-bottom: 15px;">';
    echo '<label for="razer_player_id" style="display:block; margin-bottom:5px; font-weight:bold;">معرف اللاعب (Player ID) <abbr class="required" title="مطلوب">*</abbr></label>';
    echo '<input type="text" id="razer_player_id" name="razer_player_id" value="" placeholder="أدخل معرف اللاعب" style="width:100%; padding:8px;" required />';
    echo '</div>';
}
add_action( 'woocommerce_before_add_to_cart_button', 'razer_display_player_id_field' );

function razer_validate_player_id() {
    if ( ! isset( $_POST['razer_player_id'] ) ) {
        return;
    }

    $product_id = isset( $_POST['product_id'] ) ? absint( $_POST['product_id'] ) : 0;
    if ( ! $product_id ) {
        $product_id = absint( isset( $_REQUEST['add-to-cart'] ) ? $_REQUEST['add-to-cart'] : 0 );
    }

    if ( ! $product_id ) {
        return;
    }

    $variation_id = isset( $_POST['variation_id'] ) ? absint( $_POST['variation_id'] ) : 0;
    $check_id     = $variation_id ? $variation_id : $product_id;
    $enabled      = get_post_meta( $check_id, '_razer_enable_player_id', true );

    if ( 'yes' !== $enabled ) {
        return;
    }

    $player_id = sanitize_text_field( wp_unslash( $_POST['razer_player_id'] ) );

    if ( empty( $player_id ) ) {
        wc_add_notice( 'يرجى إدخال معرف اللاعب', 'error' );
    }
}
add_action( 'woocommerce_add_to_cart_validation', 'razer_validate_player_id', 10, 0 );

function razer_add_player_id_to_cart( $cart_item_data, $product_id, $variation_id ) {
    if ( isset( $_POST['razer_player_id'] ) && ! empty( $_POST['razer_player_id'] ) ) {
        $cart_item_data['razer_player_id'] = sanitize_text_field( wp_unslash( $_POST['razer_player_id'] ) );
    }
    return $cart_item_data;
}
add_filter( 'woocommerce_add_cart_item_data', 'razer_add_player_id_to_cart', 10, 3 );

function razer_display_player_id_in_cart( $item_data, $cart_item ) {
    if ( isset( $cart_item['razer_player_id'] ) ) {
        $item_data[] = array(
            'key'   => 'معرف اللاعب',
            'value' => $cart_item['razer_player_id'],
        );
    }
    return $item_data;
}
add_filter( 'woocommerce_get_item_data', 'razer_display_player_id_in_cart', 10, 2 );

function razer_save_player_id_to_order( $item, $cart_item_key, $values, $order ) {
    if ( isset( $values['razer_player_id'] ) ) {
        $player_id = $values['razer_player_id'];
        $item->add_meta_data( 'معرف اللاعب', $player_id );
        $item->add_meta_data( '_razer_player_id', $player_id, true );
        razer_log( 'Player ID saved to order item: ' . $player_id );
    }
}
add_action( 'woocommerce_checkout_create_order_line_item', 'razer_save_player_id_to_order', 10, 4 );
