<?php
/**
 * Plugin Name: Razer Gold TopUp - Free Fire
 * Description: إضافة ووكوميرس للشحن التلقائي لماسات فري فاير عبر Razer Gold Bot
 * Version: 1.0.0
 * Author: Developer
 * Text Domain: razer-gold-topup
 * Domain Path: /languages
 * Requires at least: 5.8
 * Requires PHP: 7.4
 * WC requires at least: 6.0
 * WC tested up to: 8.5
 */

if ( ! defined( 'ABSPATH' ) ) {
    exit;
}

define( 'RAZER_GOLD_TOPUP_VERSION', '1.0.0' );
define( 'RAZER_GOLD_TOPUP_PATH', plugin_dir_path( __FILE__ ) );
define( 'RAZER_GOLD_TOPUP_URL', plugin_dir_url( __FILE__ ) );

add_action( 'before_woocommerce_init', function () {
    if ( class_exists( \Automattic\WooCommerce\Utilities\FeaturesUtil::class ) ) {
        \Automattic\WooCommerce\Utilities\FeaturesUtil::declare_compatibility( 'custom_order_tables', __FILE__, true );
    }
} );

function razer_gold_topup_check_woocommerce() {
    if ( ! class_exists( 'WooCommerce' ) ) {
        add_action( 'admin_notices', function () {
            echo '<div class="notice notice-error"><p>';
            echo esc_html__( 'Razer Gold TopUp يتطلب تثبيت وتفعيل WooCommerce', 'razer-gold-topup' );
            echo '</p></div>';
        } );
        return false;
    }
    return true;
}

function razer_gold_topup_init() {
    if ( ! razer_gold_topup_check_woocommerce() ) {
        return;
    }

    require_once RAZER_GOLD_TOPUP_PATH . 'includes/logger.php';
    require_once RAZER_GOLD_TOPUP_PATH . 'includes/api-handler.php';
    require_once RAZER_GOLD_TOPUP_PATH . 'includes/admin-settings.php';
    require_once RAZER_GOLD_TOPUP_PATH . 'includes/product-fields.php';
    require_once RAZER_GOLD_TOPUP_PATH . 'includes/order-processing.php';
    require_once RAZER_GOLD_TOPUP_PATH . 'includes/webhook.php';
}
add_action( 'plugins_loaded', 'razer_gold_topup_init' );

function razer_gold_topup_activate() {
    if ( ! wp_next_scheduled( 'razer_poll_pending_orders' ) ) {
        wp_schedule_event( time(), 'every_minute', 'razer_poll_pending_orders' );
    }
}
register_activation_hook( __FILE__, 'razer_gold_topup_activate' );

function razer_gold_topup_deactivate() {
    $timestamp = wp_next_scheduled( 'razer_poll_pending_orders' );
    if ( $timestamp ) {
        wp_unschedule_event( $timestamp, 'razer_poll_pending_orders' );
    }
}
register_deactivation_hook( __FILE__, 'razer_gold_topup_deactivate' );

add_filter( 'cron_schedules', function ( $schedules ) {
    if ( ! isset( $schedules['every_minute'] ) ) {
        $schedules['every_minute'] = array(
            'interval' => 60,
            'display'  => __( 'كل دقيقة', 'razer-gold-topup' ),
        );
    }
    return $schedules;
} );

function razer_gold_topup_ensure_cron() {
    if ( ! wp_next_scheduled( 'razer_poll_pending_orders' ) ) {
        wp_schedule_event( time(), 'every_minute', 'razer_poll_pending_orders' );
    }
}
add_action( 'init', 'razer_gold_topup_ensure_cron' );
